const { logger } = require("../../../../logger");
const fs = require("fs/promises");
const { sendMail, sendSms } = require("../../senders");
const dictionary = require("../");

const getWelcomeMessages = async () => {
  const html = await fs.readFile(__dirname + "/html.js", {
    encoding: "utf8",
  });
  const sms = await fs.readFile(__dirname + "/sms.js", {
    encoding: "utf8",
  });

  return { html, sms };
};

const sendWelcomeSms = async (client = null) => {
  if (client) {
    try {
      if (!client?.phonenumber) return;

      let { sms } = await getWelcomeMessages();
      sms = eval(sms);
      const smsInfo = {
        to: client?.phonenumber,
        message: sms,
      };

      await sendSms(smsInfo);
    } catch (error) {
      console.error(error);
      logger.error(error);
    }
  }
};

const sendWelcomeEmail = async (client = null) => {
  const mailInfo = await dictionary();
  const { subject } = mailInfo.welcome;
  if (client) {
    if (!client.email) return;
    try {
      let { html } = await getWelcomeMessages();
      html = eval(html);
      const mail = {
        subject: subject,
        to: client.email,
        html: html,
      };
      await sendMail(mail);
    } catch (error) {
      console.log(error);
      logger.error(error);
    }
  }
};

const sendWelcome = async (client = null) => {
  if (client) {
    await Promise.all([sendWelcomeEmail(client), sendWelcomeSms(client)]);
  }
};

module.exports = {
  sendWelcome,
  sendWelcomeEmail,
  sendWelcomeSms,
  getWelcomeMessages,
};
