const { logger } = require("../../../../logger");
const fs = require("fs/promises");
const { sendMail, sendSms } = require("../../senders");
const dictionary = require("..");

const getPolicyRenewedMessages = async () => {
  let html = "";
  let sms = "";

  try {
    html = await fs.readFile(__dirname + "/html.js", {
      encoding: "utf8",
    });
    sms = await fs.readFile(__dirname + "/sms.js", {
      encoding: "utf8",
    });
  } catch (error) {}

  return { html, sms };
};

const sendPolicyRenewedSMS = async (policy = null) => {
  if (policy) {
    try {
      if (!policy?.Client.phonenumber) return;

      let { sms } = await getPolicyRenewedMessages();
      sms = eval(sms);
      const smsInfo = {
        to: policy.Client.phonenumber,
        message: sms,
      };

      await sendSms(smsInfo);
    } catch (error) {
      console.error(error);
    }
  }
};

const sendPolicyRenewedEmail = async (policy = null) => {
  const mailInfo = await dictionary();
  const { subject } = mailInfo.policyRenewed;
  if (policy) {
    if (!policy?.Client.email) return;
    try {
      let { html } = await getPolicyRenewedMessages();
      html = eval(html);
      const mail = {
        subject: subject,
        to: policy.Client.email,
        html: html,
      };
      await sendMail(mail);
    } catch (error) {
      console.log(error);
      logger.error(error);
    }
  }
};

const sendPolicyRenewedMessage = async (policy = null) => {
  if (policy) {
    await Promise.all([
      sendPolicyRenewedEmail(policy),
      sendPolicyRenewedSMS(policy),
    ]);
  }
};

module.exports = {
  sendPolicyRenewedMessage,
  sendPolicyRenewedEmail,
  sendPolicyRenewedSMS,
  getPolicyRenewedMessages,
};
