const { logger } = require("../../../../logger");
const fs = require("fs/promises");
const { sendMail, sendSms } = require("../../senders");
const dictionary = require("..");

const getPolicyExpiring7Messages = async () => {
  const html = await fs.readFile(__dirname + "/html.js", {
    encoding: "utf8",
  });
  const sms = await fs.readFile(__dirname + "/sms.js", {
    encoding: "utf8",
  });

  return { html, sms };
};

const sendPolicyExpiring7SMS = async (policy = null) => {
  if (policy) {
    try {
      if (!policy?.Client.phonenumber) return;

      let { sms } = await getPolicyExpiring7Messages();
      sms = eval(sms);
      const smsInfo = {
        to: policy.Client.phonenumber,
        message: sms,
      };

      await sendSms(smsInfo);
    } catch (error) {
      logger.error(error);
    }
  }
};

const sendPolicyExpiring7Email = async (policy = null) => {
  const mailInfo = await dictionary();
  const { subject } = mailInfo.policyExpiring;
  if (policy) {
    if (!policy?.Client.email) return;
    try {
      let { html } = await getPolicyExpiring7Messages();
      html = eval(html);
      const mail = {
        subject: subject,
        to: policy.Client.email,
        html: html,
      };
      await sendMail(mail);
    } catch (error) {
      logger.error(error);
    }
  }
};

const sendPolicyExpiring7Message = async (policy = null) => {
  try {
    if (policy) {
      await Promise.all([
        sendPolicyExpiring7Email(policy),
        sendPolicyExpiring7SMS(policy),
      ]);
    }
  } catch (error) {
    logger.error(error);
  }
};

module.exports = {
  sendPolicyExpiring7Message,
  sendPolicyExpiring7Email,
  sendPolicyExpiring7SMS,
};
