const { logger } = require("../../../../logger");
const fs = require("fs/promises");
const { sendMail, sendSms } = require("../../senders");
const dictionary = require("..");

const getPolicyExpiring2Messages = async () => {
  const html = await fs.readFile(__dirname + "/html.js", {
    encoding: "utf8",
  });
  const sms = await fs.readFile(__dirname + "/sms.js", {
    encoding: "utf8",
  });

  return { html, sms };
};

const sendPolicyExpiring2SMS = async (policy = null) => {
  if (policy) {
    try {
      if (!policy?.Client.phonenumber) return;

      let { sms } = await getPolicyExpiring2Messages();
      sms = eval(sms);
      const smsInfo = {
        to: policy.Client.phonenumber,
        message: sms,
      };

      await sendSms(smsInfo);
    } catch (error) {
      logger.error(error);
    }
  }
};

const sendPolicyExpiring2Email = async (policy = null) => {
  const mailInfo = await dictionary();
  const { subject } = mailInfo.policyExpiring;
  if (policy) {
    if (!policy?.Client.email) return;
    try {
      let { html } = await getPolicyExpiring2Messages();
      html = eval(html);
      const mail = {
        subject: subject,
        to: policy.Client.email,
        html: html,
      };
      await sendMail(mail);
    } catch (error) {
      logger.error(error);
    }
  }
};

const sendPolicyExpiring2Message = async (policy = null) => {
  try {
    if (policy) {
      await Promise.all([
        sendPolicyExpiring2Email(policy),
        sendPolicyExpiring2SMS(policy),
      ]);
    }
  } catch (error) {
    logger.error(error);
  }
};

module.exports = {
  sendPolicyExpiring2Message,
  sendPolicyExpiring2Email,
  sendPolicyExpiring2SMS,
};
