const { logger } = require("../../../../logger");
const fs = require("fs/promises");
const { sendMail, sendSms } = require("../../senders");
const dictionary = require("..");

const getPolicyExpiredMessages = async () => {
  let html = "";
  let sms = "";

  try {
    html = await fs.readFile(__dirname + "/html.js", {
      encoding: "utf8",
    });
    sms = await fs.readFile(__dirname + "/sms.js", {
      encoding: "utf8",
    });
  } catch (error) {}

  return { html, sms };
};

const sendPolicyExpiredSMS = async (policy = null) => {
  if (policy) {
    try {
      if (!policy?.Client.phonenumber) return;

      let { sms } = await getPolicyExpiredMessages();
      sms = eval(sms);
      const smsInfo = {
        to: policy.Client.phonenumber,
        message: sms,
      };

      await sendSms(smsInfo);
    } catch (error) {
      console.error(error);
    }
  }
};

const sendPolicyExpiredEmail = async (policy = null) => {
  const mailInfo = await dictionary();
  const { subject } = mailInfo.policyExpired;
  if (policy) {
    if (!policy?.Client.email) return;
    try {
      let { html } = await getPolicyExpiredMessages();
      html = eval(html);
      const mail = {
        subject: subject,
        to: policy.Client.email,
        html: html,
      };
      await sendMail(mail);
    } catch (error) {
      console.log(error);
      logger.error(error);
    }
  }
};

const sendPolicyExpiredMessage = async (policy = null) => {
  if (policy) {
    await Promise.all([
      sendPolicyExpiredEmail(policy),
      sendPolicyExpiredSMS(policy),
    ]);
  }
};

module.exports = {
  sendPolicyExpiredMessage,
  sendPolicyExpiredEmail,
  sendPolicyExpiredSMS,
};
