const fs = require("fs/promises");

const dictionary = async () => {
  let dict = {};
  try {
    dict = await fs.readFile(__dirname + "/dictionary.json", {
      encoding: "utf8",
    });
  } catch (error) {
    console.log(error);
  }

  let data = {};
  const dictData = JSON.parse(dict);

  for (const [key, value] of Object.entries(dictData)) {
    let sms = "";
    let html = "";
    try {
      sms = await fs.readFile(__dirname + `/${key}/sms.js`, {
        encoding: "utf8",
      });
    } catch (error) {
      // console.log(error);
    }
    try {
      html = await fs.readFile(__dirname + `/${key}/html.js`, {
        encoding: "utf8",
      });
    } catch (error) {
      // console.log(error);
    }
    data = { ...data, [key]: { ...value, sms: sms, html: html } };
  }

  return data;
};

module.exports = dictionary;
