const { logger } = require("../../../../logger");
const fs = require("fs/promises");
const { sendMail, sendSms } = require("../../senders");
const dictionary = require("..");

const getEndOfDaySummaryMessages = async () => {
  let html = "";
  let sms = "";

  try {
    html = await fs.readFile(__dirname + "/html.js", {
      encoding: "utf8",
    });
    sms = await fs.readFile(__dirname + "/sms.js", {
      encoding: "utf8",
    });
  } catch (error) {
    logger.error(error);
  }

  return { html, sms };
};

const sendEndOfDaySummarySMS = async (summary = null, receivers = {}) => {
  logger.info("sending sendEndOfDaySummarySMS");
  if (summary) {
    try {
      if (!receivers) {
        logger.error("phone number not found");
        return;
      }

      let { sms } = await getEndOfDaySummaryMessages();
      sms = eval(sms);

      receivers.forEach(async function (phonenumber) {
        const smsInfo = {
          to: phonenumber,
          message: sms,
        };

        await sendSms(smsInfo);
      });
    } catch (error) {
      console.log(error);
      logger.error(error);
    }
  }
};

const sendEndOfDaySummaryEmail = async (summary = null, receivers = {}) => {
  const mailInfo = await dictionary();
  const { subject } = mailInfo.endOfDaySummary;
  if (policy) {
    if (!policy?.Client.email) return;
    try {
      let { html } = await getEndOfDaySummaryMessages();
      html = eval(html);
      const mail = {
        subject: subject,
        to: policy.Client.email,
        html: html,
      };
      await sendMail(mail);
    } catch (error) {
      // console.log(error);
      logger.error(error);
    }
  }
};

const sendEndOfDaySummaryMessage = async (summary = null, receivers = {}) => {
  if (summary) {
    await Promise.all([
      // sendEndOfDaySummaryEmail(summary, receivers?.email),
      sendEndOfDaySummarySMS(summary, receivers?.sms),
    ]);
  }
};

module.exports = {
  sendEndOfDaySummaryMessage,
  sendEndOfDaySummaryEmail,
  sendEndOfDaySummarySMS,
};
