const { logger } = require("../../../../logger");
const fs = require("fs/promises");
const { sendMail } = require("../../senders");
const dictionary = require("../");

const getClientWelcomeMessages = async () => {
  const html = await fs.readFile(__dirname + "/html.js", {
    encoding: "utf8",
  });
  const sms = await fs.readFile(__dirname + "/sms.js", {
    encoding: "utf8",
  });

  return { html, sms };
};

const sendClientWelcomeSms = async (user = null) => {
  if (user) {
    //console.log(user);
  }
};

const sendClientWelcomeEmail = async (user = null) => {
  const mailInfo = await dictionary();
  const { subject } = mailInfo.clientWelcome;
  if (user) {
    if (!user.email) return;
    try {
      let { html } = await getClientWelcomeMessages();
      html = eval(html);
      const mail = {
        subject: subject,
        to: user.email,
        html: html,
      };
      await sendMail(mail);
    } catch (error) {
      console.log(error);
      logger.error(error);
    }
  }
};

const sendClientWelcome = async (user = null) => {
  if (user) {
    await sendClientWelcomeEmail(user);
  }
};

module.exports = {
  sendClientWelcome,
  sendClientWelcomeEmail,
  sendClientWelcomeSms,
  getClientWelcomeMessages,
};
