require("dotenv").config();
const axios = require("axios").default;
const { logger } = require("../../../logger");

const sender = axios.create({
  baseURL: "https://api.iuapps.net/smsc/sms",
  headers: {
    authorization: `Bearer ${process.env.APP_SMS_KEY}`,
  },
});

const sendSms = async (sms) => {
  try {
    if (sms) {
      sms = { ...sms, from: process.env.APP_SMS_SEND_FROM || "SURGE" };
      sender
        .post("/send-message", sms)
        .then(function (response) {
          logger.info("sms sent");
        })
        .catch(function (error) {
          logger.error("sms sender: " + error);
        });
    }
  } catch (error) {
    logger.error(error);
  }
};

module.exports = sendSms;
