require("dotenv").config();
const nodemailer = require("nodemailer");
const { logger } = require("../../../logger");

let mailTransporter = nodemailer.createTransport({
  pool: true,
  host: process.env.APP_MAIL_HOST,
  port: process.env.APP_MAIL_PORT,
  secure: false,
  auth: {
    user: process.env.APP_MAIL_USER,
    pass: process.env.APP_MAIL_PASSWORD,
  },
});

const sendMail = async (mailDetail = {}) => {
  if (!mailDetail) {
    return;
  }
  const mailFrom = {
    name: process.env.APP_MAIL_SENDER,
    address: process.env.APP_MAIL_SEND_FROM,
  };
  try {
    mailTransporter.sendMail(
      { ...mailDetail, from: mailFrom, bcc: process.env.APP_MAIL_USER },
      function (err, data) {
        if (err) {
          logger.error(JSON.stringify(err));
        } else {
          logger.info(JSON.stringify({ ...mailDetail, ...data }));
        }
      }
    );
  } catch (error) {
    logger.error(JSON.stringify(error));
  }
};

module.exports = sendMail;
