const { Op } = require("sequelize");
const { db, sequelize, Sequelize } = require("../model");
const { workerData, parentPort } = require("worker_threads");
const { differenceInMonths, subMonths, addMonths } = require("date-fns");
const { sendPolicyExpiringMessage } = require("../notifications");

const Policy = db.policy;
const PolicyItem = db.policyItem;
const ClientPolicy = db.clientPolicy;
const Client = db.client;
const PolicyType = db.policyType;
const Company = db.company;
const Product = db.product;

const duration = differenceInMonths(
  new Date(this.effectiveDate),
  subMonths(new Date(), 1)
);

const policyExpiring = async (policy) => {
  try {
    const duration = differenceInMonths(
      new Date(policy.expires),
      addMonths(new Date(), 1)
    );

    if (duration <= 0) {
      // await sendPolicyExpiringMessage(policy);

      let markExpiring = PolicyItem.update(
        { status: "expiring" },
        {
          where: {
            id: policy.id,
          },
          individualHooks: true,
        }
      );
      markExpiring
        .then((response) => {
          //increase policy expring counter by 1
          Policy.increment(
            { expiringCount: 1 },
            {
              where: {
                id: policy.id,
              },
              individualHooks: true,
            }
          );
        })
        .catch((resp) => {});
      markExpiring.catch();

      if (policy.ClientPolicyId) {
        markExpiring = ClientPolicy.update(
          { status: "expiring" },
          {
            where: {
              id: policy.ClientPolicyId,
            },
            individualHooks: true,
          }
        );
        markExpiring.then((response) => {
          //console.log(response);
        });
        markExpiring.catch();
      }
    }
  } catch (error) {
    console.log(error);
  }
};

const policies = PolicyItem.findAll({
  where: {
    status: "active",
  },
  include: [
    { model: Company },
    { model: Client },
    { model: PolicyType },
    { model: Product },
  ],
  limit: 20,
});
policies.then((responses) => {
  responses.forEach((response) => {
    //console.log(response);
    policyExpiring(response);
  });
});
policies.catch((error) => {
  console.error(error);
});
parentPort.postMessage("done");
