const { Op } = require("sequelize");
const { db, sequelize, Sequelize } = require("../../model");
const { workerData, parentPort } = require("worker_threads");
const { sendPolicyExpiringMessage } = require("../../notifications");
const { logger } = require("../../../logger");
const { addMonths, addDays } = require("date-fns");

const sendNotice = async (marked = {}) => {
  try {
    const expiringPolicies = await db.policyMark.findAll({
      where: {
        PolicyId: marked?.PolicyId,
        mark: "expiring",
        state: false,
      },
      include: [
        {
          model: db.clientPolicy,
          include: [
            { model: db.company },
            { model: db.branch },
            { model: db.policyType },
            { model: db.product },
          ],
        },
      ],
    });

    const policy = await db.policy.findByPk(marked?.PolicyId, {
      include: [{ model: db.client }],
    });

    policy.items = expiringPolicies;
    await sendPolicyExpiringMessage(policy);

    await db.policyMark.update(
      { state: true },
      {
        where: {
          PolicyId: marked?.PolicyId,
          mark: "expiring",
          state: false,
        },
      }
    );
  } catch (error) {
    console.log(error);
    logger.error(error);
  }
};

const prepareData = async () => {};

try {
  const days = 2;
  db.policyMark
    .findAll({
      where: {
        mark: "expiring",
        state: false,
        createdAt: {
          [Op.lte]: addDays(new Date(), days),
          [Op.gt]: new Date(),
        },
      },
      attributes: ["PolicyId"],
      group: ["PolicyId"],
    })
    .then((policies) => {
      policies.forEach((policy) => {
        console.log(
          `${policy.policyNumber}-${policy.status}-${policy.expires}-notifer31`
        );
        sendNotice(policy);
      });
    })
    .catch((error) => {
      logger.error(error);
    });
} catch (error) {
  logger.error(error);
}
