const { Op } = require("sequelize");
const { db, sequelize, Sequelize } = require("../../model");
const { workerData, parentPort } = require("worker_threads");
const { sendPolicyExpiredMessage } = require("../../notifications");
const { logger } = require("../../../logger");
const { addMonths, addDays } = require("date-fns");

const sendNotice = async (marked = {}) => {
  try {
    const expiredPolicies = await db.policyMark.findAll({
      where: {
        PolicyId: marked?.PolicyId,
        mark: "expired",
        state: false,
      },
      include: [
        {
          model: db.clientPolicy,
          include: [
            { model: db.company },
            { model: db.branch },
            { model: db.policyType },
            { model: db.product },
          ],
        },
      ],
    });

    const policy = await db.policy.findByPk(marked?.PolicyId, {
      include: [{ model: db.client }],
    });

    policy.items = expiredPolicies;
    await sendPolicyExpiredMessage(policy);

    await db.policyMark.update(
      { state: true },
      {
        where: {
          PolicyId: marked?.PolicyId,
          mark: "expired",
          state: false,
        },
      }
    );
  } catch (error) {
    console.log(error);
    logger.error(error);
  }
};

const prepareData = async () => {};

try {
  const days = 2;
  db.policyMark
    .findAll({
      where: {
        mark: "expired",
        state: false,
        createdAt: {
          [Op.lte]: addDays(new Date(), days),
          [Op.gt]: new Date(),
        },
      },
      attributes: ["PolicyId"],
      group: ["PolicyId"],
    })
    .then((policies) => {
      policies.forEach((policy) => {
        sendNotice(policy);
      });
    })
    .catch((error) => {
      logger.error(error);
    });
} catch (error) {
  logger.error(error);
}
