const { logger } = require("../../../logger");
const { Worker } = require("worker_threads");

const runNotifiers = () => {
  const expiringNotifier = new Promise((resolve, reject) => {
    const worker = new Worker("./src/app/cron/notifiers/notifyExpiring.js");
    worker.on("message", resolve);
    worker.on("error", reject);
    worker.on("exit", (code) => {
      if (code !== 0)
        reject(new Error(`Worker stopped with exit code ${code}`));
    });
  });

  const alert30Notifier = new Promise((resolve, reject) => {
    const worker = new Worker("./src/app/cron/notifiers/notify30.js");
    worker.on("message", resolve);
    worker.on("error", reject);
    worker.on("exit", (code) => {
      if (code !== 0)
        reject(new Error(`Worker stopped with exit code ${code}`));
    });
  });

  const alert7Notifier = new Promise((resolve, reject) => {
    const worker = new Worker("./src/app/cron/notifiers/notify7.js");
    worker.on("message", resolve);
    worker.on("error", reject);
    worker.on("exit", (code) => {
      if (code !== 0)
        reject(new Error(`Worker stopped with exit code ${code}`));
    });
  });

  const alert2Notifier = new Promise((resolve, reject) => {
    const worker = new Worker("./src/app/cron/notifiers/notify2.js");
    worker.on("message", resolve);
    worker.on("error", reject);
    worker.on("exit", (code) => {
      if (code !== 0)
        reject(new Error(`Worker stopped with exit code ${code}`));
    });
  });

  const expiredNotifier = new Promise((resolve, reject) => {
    const worker = new Worker("./src/app/cron/notifiers/notifyExpired.js");
    worker.on("message", resolve);
    worker.on("error", reject);
    worker.on("exit", (code) => {
      if (code !== 0)
        reject(new Error(`Worker stopped with exit code ${code}`));
    });
  });

  return [
    expiringNotifier,
    alert30Notifier,
    alert7Notifier,
    alert2Notifier,
    expiredNotifier,
  ];
};

const runSummaryNotifiers = () => {
  const endOfDaySummaryNotifier = new Promise((resolve, reject) => {
    const worker = new Worker("./src/app/cron/notifiers/endOfDaySummary.js");
    worker.on("message", resolve);
    worker.on("error", reject);
    worker.on("exit", (code) => {
      if (code !== 0)
        reject(new Error(`Worker stopped with exit code ${code}`));
    });
  });

  return [endOfDaySummaryNotifier];
};

module.exports = { runNotifiers, runSummaryNotifiers };
