const { logger } = require("../../../logger");
require("dotenv").config();
const { Op } = require("sequelize");
const { db, sequelize, Sequelize } = require("../../model");
const { workerData, parentPort } = require("worker_threads");
const { sendEndOfDaySummaryMessage } = require("../../notifications");

const sendNotice = async () => {
  try {
    let summaries = await db.summaryReport.todayUnsentEndOfDay();
    // logger.info(process.env.SUMMARY_END_OF_DAY_SMS_RECEIVERS?.split(","));

    if (summaries) {
      summaries.forEach(async (report) => {
        if (report.summary) {
          const summary = JSON.parse(report.summary);
          await sendEndOfDaySummaryMessage(summary, {
            sms: process.env.SUMMARY_END_OF_DAY_SMS_RECEIVERS?.split(",") || [],
            email:
              process.env.SUMMARY_END_OF_DAY_EMAIL_RECEIVERS?.split(",") || [],
          });
          await report.markSent();
        }
      });
    }
  } catch (error) {
    console.log(error);
    logger.info(error);
  }
};

try {
  sendNotice();
} catch (error) {
  logger.error(error);
}
if (process.env.CRON_LOG_SHOW) {
  parentPort.postMessage("End of summary run");
}
