const { Op } = require("sequelize");
const { db, sequelize, Sequelize } = require("../../model");
const { workerData, parentPort } = require("worker_threads");

const PolicyMark = db.policyMark;

const markPolicy = async (policy, mark) => {
  try {
    if (policy) {
      const policyMark = {
        PolicyId: policy.PolicyId,
        ClientPolicyId: policy.ClientPolicyId,
        mark: mark,
        state: false,
      };

      const constraint = {
        ClientPolicyId: policy.ClientPolicyId,
        mark: mark,
        state: false,
      };
      const [marker, created] = await PolicyMark.findOrCreate({
        where: constraint,
        defaults: policyMark,
      });

      if (["expiring", "expired"].includes(mark)) {
        if (policy.ClientPolicyId) {
          db.clientPolicy.update(
            {
              status: mark,
            },
            {
              where: { id: policy.ClientPolicyId },
              individualHooks: true,
            }
          );
        }

        // policy.update(
        //   { status: mark },
        //   {
        //     where: { id: policy.id },
        //     individualHooks: true,
        //   }
        // );
      }

      if (created) {
      }
    }
  } catch (error) {
    console.error(error);
  }
};

module.exports = { markPolicy };
