const { logger } = require("../../../logger");
const { Worker } = require("worker_threads");

const runSummaryMarkers = () => {
    const endOfDaySummaryMarker = new Promise((resolve, reject) => {
    const worker = new Worker("./src/app/cron/markers/summary/endOfDay.js");
    worker.on("message", resolve);
    worker.on("error", reject);
    worker.on("exit", (code) => {
      if (code !== 0)
        reject(new Error(`Worker stopped with exit code ${code}`));
    });
  });
  
  return [
    endOfDaySummaryMarker,
  ];
}

const runMarkers = () => {
  const expiringMarker = new Promise((resolve, reject) => {
    const worker = new Worker("./src/app/cron/markers/expiring.js");
    worker.on("message", resolve);
    worker.on("error", reject);
    worker.on("exit", (code) => {
      if (code !== 0)
        reject(new Error(`Worker stopped with exit code ${code}`));
    });
  });

  const alert30Marker = new Promise((resolve, reject) => {
    const worker = new Worker("./src/app/cron/markers/alert30.js");
    worker.on("message", resolve);
    worker.on("error", reject);
    worker.on("exit", (code) => {
      if (code !== 0)
        reject(new Error(`Worker stopped with exit code ${code}`));
    });
  });

  const alert7Marker = new Promise((resolve, reject) => {
    const worker = new Worker("./src/app/cron/markers/alert7.js");
    worker.on("message", resolve);
    worker.on("error", reject);
    worker.on("exit", (code) => {
      if (code !== 0)
        reject(new Error(`Worker stopped with exit code ${code}`));
    });
  });

  const alert2Marker = new Promise((resolve, reject) => {
    const worker = new Worker("./src/app/cron/markers/alert2.js");
    worker.on("message", resolve);
    worker.on("error", reject);
    worker.on("exit", (code) => {
      if (code !== 0)
        reject(new Error(`Worker stopped with exit code ${code}`));
    });
  });

  const expiredMarker = new Promise((resolve, reject) => {
    const worker = new Worker("./src/app/cron/markers/expired.js");
    worker.on("message", resolve);
    worker.on("error", reject);
    worker.on("exit", (code) => {
      if (code !== 0)
        reject(new Error(`Worker stopped with exit code ${code}`));
    });
  });

  const endOfDaySummaryMarker = new Promise((resolve, reject) => {
    const worker = new Worker("./src/app/cron/markers/summary/endOfDay.js");
    worker.on("message", resolve);
    worker.on("error", reject);
    worker.on("exit", (code) => {
      if (code !== 0)
        reject(new Error(`Worker stopped with exit code ${code}`));
    });
  });

  return [
    expiringMarker,
    alert30Marker,
    alert7Marker,
    alert2Marker,
    expiredMarker,
    endOfDaySummaryMarker,
  ];
};

module.exports = { runMarkers, runSummaryMarkers };
