const { Op } = require("sequelize");
const { db, sequelize, Sequelize } = require("../../model");
const { workerData, parentPort } = require("worker_threads");
const { addMonths, addDays } = require("date-fns");
const { markPolicy } = require("./util");
const { logger } = require("../../../logger");

const ClientPolicy = db.policyItem;

const days = 31;

const policies = ClientPolicy.findAll({
  where: {
    status: "active",
    expires: {
      [Op.lte]: addDays(new Date(), days),
      [Op.gt]: new Date(),
    },
    RenewedId: { [Op.is]: null },
  },
});
policies.then((data) => {
  data.forEach((policy) => {
    console.log(
      `${policy.policyNumber}-${policy.status}-${policy.expires}-expiring`
    );
    markPolicy(policy, "expiring");
  });
});
policies.catch((error) => {
  console.error(error);
  logger.error(error);
});

parentPort.postMessage("expiring done");
