const { Op } = require("sequelize");
const { db, sequelize, Sequelize } = require("../../model");
const { workerData, parentPort } = require("worker_threads");
const { addMonths, addDays } = require("date-fns");
const { markPolicy } = require("./util");
const { logger } = require("../../../logger");

const ClientPolicy = db.policyItem;

const days = 0;

const policies = ClientPolicy.findAll({
  where: {
    status: { [Op.in]: ["active", "expiring"] },
    expires: {
      // [Op.lt]: new Date(),
      // [Op.gt]: new Date(new Date() - 24 * 60 * 60 * 1000),
      [Op.lte]: addDays(new Date(), days),
    },
    RenewedId: { [Op.is]: null },
  },
});
policies.then((data) => {
  data.forEach((policy) => {
    markPolicy(policy, "expired");
  });
});
policies.catch((error) => {
  console.error(error);
  logger.error(error);
});

const runOutPolicies = ClientPolicy.findAll({
  where: {
    status: { [Op.in]: ["active", "expiring"] },
    expires: {
      [Op.lte]: addDays(new Date(), days),
    },
    RenewedId: { [Op.is]: null },
  },
});

runOutPolicies.then((data) => {
  data.forEach((policy) => {
    logger.info(
      `${policy?.policyNumber}-${policy?.expires}-${policy?.status}-expired pass`
    );
    console.log(
      `${policy?.policyNumber}-${policy?.expires}-${policy?.status}-expired pass`
    );
  });
});
runOutPolicies.catch((error) => {
  console.error(error);
  logger.error(error);
});

parentPort.postMessage("expired done");
