const { Op } = require("sequelize");
const { db, sequelize, Sequelize } = require("../../model");
const { workerData, parentPort } = require("worker_threads");
const { addMonths, addDays } = require("date-fns");
const { markPolicy } = require("./util");
const { logger } = require("../../../logger");

const ClientPolicy = db.clientPolicy;

const days = 7;

const policies = ClientPolicy.findAll({
  where: {
    status: { [Op.in]: ["active", "expiring"] },
    expires: {
      [Op.eq]: addDays(new Date(), days),
    },
    RenewedId: { [Op.is]: null },
  },
});
policies.then((data) => {
  data.forEach((policy) => {
    console.log(
      `${policy.policyNumber}-${policy.status}-${policy.expires}-alert7`
    );
    markPolicy(policy, "alert7");
  });
});
policies.catch((error) => {
  console.error(error);
  logger.error(error);
});

parentPort.postMessage("alert7 done");
