const { Op } = require("sequelize");
const { db, sequelize, Sequelize } = require("../../model");
const { workerData, parentPort } = require("worker_threads");
const { addMonths, addDays } = require("date-fns");
const { markPolicy } = require("./util");

const ClientPolicy = db.clientPolicy;

const days = 60;

const policies = ClientPolicy.findAll({
  where: {
    status: { [Op.in]: ["active", "expiring"] },
    expires: {
      [Op.lte]: addDays(new Date(), days),
      [Op.gt]: new Date(),
    },
    RenewedId: { [Op.is]: null },
  },
});
policies.then((data) => {
  data.forEach((policy) => {
    markPolicy(policy, "alert60");
  });
});
policies.catch((error) => {
  console.error(error);
});

parentPort.postMessage("done");
