require("dotenv").config();
const cron = require("node-cron");
const { logger } = require("../../logger");
const { Worker } = require("worker_threads");
const config = require("../../config/cron.config.js");
const { runMarkers, runSummaryMarkers } = require("./markers");
const { runNotifiers, runSummaryNotifiers } = require("./notifiers");

console.log("cron loaded");

logger.info("cron loaded");

// function runService(workerData) {
//   return new Promise((resolve, reject) => {
//     const worker = new Worker("./src/app/cron/policy_cron.js", { workerData });
//     worker.on("message", resolve);
//     worker.on("error", reject);
//     worker.on("exit", (code) => {
//       if (code !== 0)
//         reject(new Error(`Worker stopped with exit code ${code}`));
//     });
//   });
// }

// cron.schedule("* * * * *", () => {
//   async function run() {
//       logger.info("summary");
//   const result = await Promise.all(runSummaryMarkers());
//     console.log(result);
//   }
//   run().catch((err) => logger.error("cron", err));
// });

cron.schedule(config.markerWindow, () => {
  async function run() {
    //   logger.info("summary1");
    const result = await Promise.all(runMarkers());
    console.log(result);
    logger.info(result);
  }
  run().catch((err) => logger.error("cron", err));
});

cron.schedule(config.notifierWindow, () => {
  async function run() {
    const result = await Promise.all(runNotifiers());
    console.log(result);
    logger.info(result);
  }
  run().catch((err) => logger.error("cron", err));
});

cron.schedule(config.summaryReportDispatchWindow, () => {
  //   console.log("loading summary");
  async function run() {
    const result = await Promise.all(runSummaryNotifiers());
    console.log(result);
    logger.info(result);
  }
  run().catch((err) => {
    console.error("cron", err);
    logger.error("cron", err);
  });
});
